<?php

namespace WTS_EAE\Modules\ProgressBar\Skins;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;


class Skin_2 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/eae-progress-bar/skin2_general_style/before_section_end', [
			$this,'extra_controls_add'
		] );
	}

	public function get_id() {
		return 'skin2';
	}

	public function get_title() {
		return __( 'Skin 2', 'wts-eae' );
	}

	public function extra_controls_add() {
		//linear-gradient(to top, rgba(255, 255, 255, 0.15), rgba(0, 0, 0, 0.2)),
		//linear-gradient(135deg, {{progress_color_1.VALUE}}, {{progress_color_1.VALUE}} 33%, {{progress_color_2.VALUE}} 33%, {{progress_color_2.VALUE}} 66%, {{progress_color_1.VALUE}} 66%);

		$this->remove_control('progress_color');

		$this->add_control(
			'progress_color_1',
			[
				'label'     => __( 'Progress Color 1', 'wts-eae' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .eae-pb-bar-inner' => 'background-image: linear-gradient(to top, rgba(255, 255, 255, 0.15), rgba(0, 0, 0, 0.2)),linear-gradient(135deg, {{skin2_progress_color_1.VALUE}}, {{skin2_progress_color_1.VALUE}} 33%, {{skin2_progress_color_2.VALUE || "#358600" }} 33%, {{skin2_progress_color_2.VALUE || "#358600" }} 66%, {{skin2_progress_color_1.VALUE}} 66%);',
				],
			]
		);
		$this->add_control(
			'progress_color_2',
			[
				'label'     => __( 'Progress Color 2', 'wts-eae' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .eae-pb-bar-inner' => 'background-image: linear-gradient(to top, rgba(255, 255, 255, 0.15), rgba(0, 0, 0, 0.2)),linear-gradient(135deg, {{skin2_progress_color_1.VALUE || "#5EEB5B"}}, {{skin2_progress_color_1.VALUE || "#5EEB5B"}} 33%, {{skin2_progress_color_2.VALUE}} 33%, {{skin2_progress_color_2.VALUE}} 66%, {{skin2_progress_color_1.VALUE || "#5EEB5B"}} 66%);',
				],
			]
		);
	}

	public function register_style_controls() {
		parent::register_style_controls(); // TODO: Change the autogenerated stub
	}

	function render(){
		$this->common_render();
	}

}