<?php

namespace WTS_EAE\Modules\Timeline\Skins;

use Elementor\Widget_Base;


class Skin_2 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/eae-timeline/skin2_icon_global_style/after_section_end', [ $this, 'extra_control' ] );
		add_action( 'elementor/element/eae-timeline/skin2_section_global_icon/after_section_end', [ $this, 'update_icon_control' ] );
	}

	public function get_id() {
		return 'skin2';
	}

	public function get_title() {
		return __( 'Skin 2', 'wts-eae' );
	}
	public function register_items_control( Widget_Base $widget ) {
		$this->parent = $widget;
		//$this->bpel_timeline_content_section( );
	}
	public function register_style_controls() {
		parent::register_style_controls(); // TODO: Change the autogenerated stub
		$this->eae_timeline_style_section();

	}

	function update_icon_control(){
		$this->update_control(
			'global_icon_view',
			[
				'default' => 'framed',
			]
		);
	}

	function extra_control(){
		$this->update_control(
			'item_icon_icon_size',
			[
				'default' => [
					'size' => 25,
				],
			]
		);
		$this->update_control(
			'item_icon_icon_padding',
			[
				'default' => [
					'size' => 7,
				],
			]
		);
		$this->update_control(
			'arrow_align',
			[
				'default' => 'center',
			]
		);
		$this->update_control(
			'tl_alternate_style',
			[
				'default' => 'yes',
			]
		);
		$this->update_control(
			'content_padding',
			[
				'default'   => [
					'top' => 10,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
				],
			]
		);
		$this->update_control(
			'item_icon_icon_focus_secondary_color',
			[
				'default'   => '#fff',
			]
		);
		$this->update_control(
			'item_icon_icon_focus_primary_color',
			[
				'default'   => '#23a455'
			]
		);
	}

	public function render() {
		$this->common_render();
	}
}
