<?php

namespace WTS_EAE\Modules\EvergreenTimer\Skins;

use Elementor\Controls_Manager;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;

class Skin_2 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/eae-evergreen-timer/skin2_time_text_style/before_section_end', [
			$this,
			'extra_controls_update'
		] );
		add_action( 'elementor/element/eae-evergreen-timer/skin2_general_style/before_section_end', [
			$this,
			'add_controls'
		] );
	}

	public function get_id() {
		return 'skin2';
	}

	public function get_title() {
		return __( 'Skin 2', 'wts-eae' );
	}

	function extra_controls_update() {
		$this->remove_control( 'wrapper_bg_color' );
		$this->remove_responsive_control( 'wrapper_padding' );
		//$this->remove_responsive_control('box_border');
		$this->remove_control( 'border_radius' );
		$this->remove_responsive_control( 'time_num_padding' );
		$this->remove_responsive_control( 'time_text_padding' );

		$this->add_responsive_control(
			'time_label_margin',
			[
				'label'      => __( 'Margin', 'wts-eae' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}}[data-element_type="eae-evergreen-timer.skin2"] .flip-clock-divider .flip-clock-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	}

	function add_controls() {
		$this->add_responsive_control(
			'item_height',
			[
				'label'          => __( 'Height', 'wts-eae' ),
				'type'           => Controls_Manager::SLIDER,
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'        => [
					'size' => 90,
				],
				'mobile_default' => [
					'size' => 30,
				],
				'selectors'      => [
					'{{WRAPPER}}[data-element_type="eae-evergreen-timer.skin2"] .eae-flip-clock-wrapper ul'    => 'height: {{SIZE}}{{UNIT}} !important;',
					'{{WRAPPER}}[data-element_type="eae-evergreen-timer.skin2"] .flip-clock-divider'           => 'height: calc({{SIZE}}{{UNIT}} + 10px) !important;',
					'{{WRAPPER}}[data-element_type="eae-evergreen-timer.skin2"] .eae-flip-clock-wrapper ul li' => 'line-height: calc({{SIZE}}{{UNIT}} - 3px) !important;',
				],
			]
		);
		$this->add_responsive_control(
			'item_width',
			[
				'label'          => __( 'Width', 'wts-eae' ),
				'type'           => Controls_Manager::SLIDER,
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'        => [
					'size' => 60,
				],
				'mobile_default' => [
					'size' => 25,
				],
				'selectors'      => [
					'{{WRAPPER}}[data-element_type="eae-evergreen-timer.skin2"] .eae-flip-clock-wrapper ul' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
	}

	function render() {
		$data     = $this->parent->get_data();
		$settings = $this->parent->get_settings_for_display();

		$actions = $this->eae_get_egt_actions( $settings );
		//echo '<pre>';print_r($settings);echo '</pre>';
		if ( $settings['action_after_expire'] !== '' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-actions', json_encode( $settings['action_after_expire'] ) );
			if ( $settings['redirect_url_expire'] !== '' ) {
				$this->parent->add_render_attribute( 'wrapper', 'data-redirected-url', $settings['redirect_url_expire'] );
			}
		} else {
			$this->parent->add_render_attribute( 'wrapper', 'data-actions', '[""]' );
		}

		$cookie_temp_name = "eae-temp-" . $data['id'];
		$cookie_name      = "eae-temp-" . $data['id'];
		$show_data        = 'show';
		if ( isset( $_COOKIE[ $cookie_temp_name ] ) ) {
			//echo 'cookie set';
			//echo 'cookie value'. $_COOKIE[$cookie_temp_name];
		} else {
			$this->parent->add_render_attribute( 'wrapper', 'class', 'eae-evergreen-expire' );

			if ( ! Plugin::instance()->editor->is_edit_mode() ) {
				if ( $settings['action_after_expire'] !== '' ) {
					foreach ( $actions as $index => $item ) :
						if ( $item['type'] == 'redirect' || $item['type'] == 'hide_parent' || $item['type'] == 'hide' ) {
							$show_data = 'hide';
						}
					endforeach;
				}
			}
		}

		$unqId = 'eae-egt-' . rand();
		$this->parent->add_render_attribute( 'wrapper', 'class', 'eae-evergreen-wrapper' );
		$this->parent->add_render_attribute( 'wrapper', 'class', $unqId );
		$this->parent->add_render_attribute( 'wrapper', 'data-unqid', $unqId );
		$this->parent->add_render_attribute( 'wrapper', 'data-id', $data['id'] );
		$this->parent->add_render_attribute( 'wrapper', 'data-element-type', $settings['countdown_type'] );
		$this->parent->add_render_attribute( 'wrapper', 'data-egtime', $this->get_egt_interval( $settings ) );
		$this->parent->add_render_attribute( 'wrapper', 'data-egt-expire', $settings['egt_expiry'] );

		$this->parent->add_render_attribute( 'wrapper_days', 'class', 'eae-time-wrapper' );
		if ( $settings['show_days'] !== 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper_days', 'class', 'eae-egt-hide' );
		}
		$this->parent->add_render_attribute( 'wrapper_hours', 'class', 'eae-time-wrapper' );
		if ( $settings['show_hours'] !== 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper_hours', 'class', 'eae-egt-hide' );
		}
		$this->parent->add_render_attribute( 'wrapper_minutes', 'class', 'eae-time-wrapper' );
		if ( $settings['show_minutes'] !== 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper_minutes', 'class', 'eae-egt-hide' );
		}
		$this->parent->add_render_attribute( 'wrapper_seconds', 'class', 'eae-time-wrapper' );
		if ( $settings['show_seconds'] !== 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper_seconds', 'class', 'eae-egt-hide' );
		}
		?>

        <div <?php echo $this->parent->get_render_attribute_string( 'wrapper' ); ?>>

			<?php if ( $show_data === 'show' ) { ?>
                <h2 class="egt-title"><?php echo $settings['countdown_title'] ?></h2>
                <div class="timer-container">
                    <div class="eae-flip-clock-wrapper">
						<?php
						if ( $settings['show_days'] == 'yes' ) {
							?>
                            <span class="flip-clock-divider days"><span
                                        class="flip-clock-label egt-time-text">Days</span><span
                                        class="flip-clock-dot top"></span><span
                                        class="flip-clock-dot bottom"></span></span>
                            <ul data-id="eaeulDay" id="eaeulDay" class="flip play seconds">
                                <li data-digit="0" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                    </a></li>
                                <li data-digit="1" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                    </a></li>
                                <li data-digit="2" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                    </a></li>
                                <li data-digit="3"><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                    </a></li>
                                <li data-digit="4" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                    </a></li>
                                <li data-digit="5" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                    </a></li>
                                <li data-digit="6" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                    </a></li>
                                <li data-digit="7" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                    </a></li>
                                <li data-digit="8" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                    </a></li>
                                <li data-digit="9" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                    </a></li>
                            </ul>
                            <ul data-id="eaeulDay1" id="eaeulDay1" class="flip play minutes">
                                <li data-digit="0" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                    </a></li>
                                <li data-digit="1" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                    </a></li>
                                <li data-digit="2" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                    </a></li>
                                <li data-digit="3"><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                    </a></li>
                                <li data-digit="4" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                    </a></li>
                                <li data-digit="5" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                    </a></li>
                                <li data-digit="6" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                    </a></li>
                                <li data-digit="7" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                    </a></li>
                                <li data-digit="8" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                    </a></li>
                                <li data-digit="9" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                    </a></li>
                            </ul>
							<?php
						}
						if ( $settings['show_hours'] == 'yes' ) {
							?>
                            <span class="flip-clock-divider hours"><span
                                        class="flip-clock-label egt-time-text">Hours</span><span
                                        class="flip-clock-dot top"></span><span
                                        class="flip-clock-dot bottom"></span></span>
                            <ul data-id="eaeulHour" id="eaeulHour" class="flip play seconds">
                                <li data-digit="0" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                    </a></li>
                                <li data-digit="1" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                    </a></li>
                                <li data-digit="2" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                    </a></li>
                                <li data-digit="3"><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                    </a></li>
                                <li data-digit="4" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                    </a></li>
                                <li data-digit="5" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                    </a></li>
                            </ul>
                            <ul data-id="eaeulHour1" id="eaeulHour1" class="flip play minutes">
                                <li data-digit="0" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                    </a></li>
                                <li data-digit="1" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                    </a></li>
                                <li data-digit="2" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                    </a></li>
                                <li data-digit="3"><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                    </a></li>
                                <li data-digit="4" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                    </a></li>
                                <li data-digit="5" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                    </a></li>
                                <li data-digit="6" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                    </a></li>
                                <li data-digit="7" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                    </a></li>
                                <li data-digit="8" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                    </a></li>
                                <li data-digit="9" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                    </a></li>
                            </ul>
							<?php
						}
						if ( $settings['show_minutes'] == 'yes' ) {
							?>
                            <span class="flip-clock-divider minutes"><span class="flip-clock-label egt-time-text">Minutes</span><span
                                        class="flip-clock-dot top"></span><span
                                        class="flip-clock-dot bottom"></span></span>
                            <ul data-id="eaeulMin" id="eaeulMin" class="flip play seconds">
                                <li data-digit="0" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                    </a></li>
                                <li data-digit="1" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                    </a></li>
                                <li data-digit="2" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                    </a></li>
                                <li data-digit="3"><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                    </a></li>
                                <li data-digit="4" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                    </a></li>
                                <li data-digit="5" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                    </a></li>
                            </ul>
                            <ul data-id="eaeulMin1" id="eaeulMin1" class="flip play minutes">
                                <li data-digit="0" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                    </a></li>
                                <li data-digit="1" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                    </a></li>
                                <li data-digit="2" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                    </a></li>
                                <li data-digit="3"><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                    </a></li>
                                <li data-digit="4" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                    </a></li>
                                <li data-digit="5" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                    </a></li>
                                <li data-digit="6" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                    </a></li>
                                <li data-digit="7" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                    </a></li>
                                <li data-digit="8" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                    </a></li>
                                <li data-digit="9" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                    </a></li>
                            </ul>
							<?php
						}
						if ( $settings['show_seconds'] == 'yes' ) {
							?>
                            <span class="flip-clock-divider seconds"><span class="flip-clock-label egt-time-text">Seconds</span><span
                                        class="flip-clock-dot top"></span><span
                                        class="flip-clock-dot bottom"></span></span>
                            <ul data-id="eaeulSec1" id="eaeulSec" class="flip play seconds">
                                <li data-digit="0" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                    </a></li>
                                <li data-digit="1" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                    </a></li>
                                <li data-digit="2" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                    </a></li>
                                <li data-digit="3"><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                    </a></li>
                                <li data-digit="4" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                    </a></li>
                                <li data-digit="5" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                    </a></li>
                            </ul>
                            <ul data-id="eaeulSec1" id="eaeulSec1" class="flip play minutes">
                                <li data-digit="0" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">0</div>
                                        </div>
                                    </a></li>
                                <li data-digit="1" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">1</div>
                                        </div>
                                    </a></li>
                                <li data-digit="2" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">2</div>
                                        </div>
                                    </a></li>
                                <li data-digit="3"><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">3</div>
                                        </div>
                                    </a></li>
                                <li data-digit="4" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">4</div>
                                        </div>
                                    </a></li>
                                <li data-digit="5" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">5</div>
                                        </div>
                                    </a></li>
                                <li data-digit="6" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">6</div>
                                        </div>
                                    </a></li>
                                <li data-digit="7" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">7</div>
                                        </div>
                                    </a></li>
                                <li data-digit="8" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">8</div>
                                        </div>
                                    </a></li>
                                <li data-digit="9" class=""><a href="#" class="">
                                        <div class="up">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                        <div class="down">
                                            <div class="shadow"></div>
                                            <div class="inn egt-time">9</div>
                                        </div>
                                    </a></li>
                            </ul>
							<?php
						}
						?>
                    </div>
                </div>
			<?php } ?>
            <div class="eae-egt-message">
				<?php echo do_shortcode( $settings['expire_message'] ); ?>
            </div>
        </div>
		<?php
	}
}